/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos.config;

import cz.insophy.inplan.planning.mokos.Scheduler;
import javax.annotation.Nonnull;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchedulerDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String SUCCESSORS_PROPERTY = "successors";
    private ManagedList<BeanReference> allProcessors;

    protected boolean shouldGenerateId() {
        return true;
    }

    protected String getBeanClassName(Element element) {
        return Scheduler.class.getName();
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder schedulerBean) {
        if ("scheduler".equals(element.getLocalName())) {
            schedulerBean.addPropertyReference("superplan", "superplan");
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                Element childEl = (Element)child;
                if ("pipeline".equals(childEl.getLocalName())) {
                    this.allProcessors = new ManagedList();
                    this.parsePipeline(childEl, parserContext);
                    schedulerBean.addPropertyValue("processors", this.allProcessors);
                    continue;
                }
                if ("property".equals(childEl.getLocalName())) {
                    parserContext.getDelegate().parsePropertyElement(childEl, (BeanDefinition)schedulerBean.getBeanDefinition());
                    continue;
                }
                parserContext.getReaderContext().error("Unknown element " + childEl.getLocalName() + " found under in scheduler definition.", (Object)childEl);
            }
        } else {
            parserContext.getReaderContext().error("Expected scheduler definition.", (Object)element);
        }
    }

    private ManagedList<BeanReference> parsePipeline(Element element, ParserContext parserContext) {
        ManagedList pipeline = new ManagedList();
        BeanDefinition prevProcessor = null;
        NodeList childNodes = element.getChildNodes();
        block10: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            Element childEl = (Element)child;
            switch (childEl.getLocalName()) {
                case "lexicographic-selector": {
                    BeanDefinition selector = parserContext.getDelegate().parseCustomElement(childEl);
                    BeanDefinitionHolder selHolder = new BeanDefinitionHolder(selector, "selector");
                    prevProcessor = this.hookProcessor(parserContext, (ManagedList<BeanReference>)pipeline, prevProcessor, selHolder);
                    continue block10;
                }
                case "bean": {
                    BeanDefinitionHolder bean = parserContext.getDelegate().parseBeanDefinitionElement(childEl);
                    prevProcessor = this.hookProcessor(parserContext, (ManagedList<BeanReference>)pipeline, prevProcessor, bean);
                    continue block10;
                }
                case "pipeline": {
                    BeanReference pipelineStart = (BeanReference)this.parsePipeline(childEl, parserContext).get(0);
                    if (prevProcessor != null) {
                        PropertyValue succProperty = prevProcessor.getPropertyValues().getPropertyValue(SUCCESSORS_PROPERTY);
                        if (succProperty == null) {
                            succProperty = new PropertyValue(SUCCESSORS_PROPERTY, (Object)new ManagedList());
                            prevProcessor.getPropertyValues().addPropertyValue(succProperty);
                        }
                        ManagedList successors = (ManagedList)succProperty.getValue();
                        successors.add((Object)pipelineStart);
                        continue block10;
                    }
                    parserContext.getReaderContext().error("Pipeline definition must be preceded by at least 1 processor (bean element).", (Object)childEl);
                    continue block10;
                }
                default: {
                    parserContext.getReaderContext().error("Unknown element found in pipeline definition.", (Object)childEl);
                }
            }
        }
        return pipeline;
    }

    @Nonnull
    private BeanDefinition hookProcessor(ParserContext parserContext, ManagedList<BeanReference> pipeline, BeanDefinition prevProcessor, BeanDefinitionHolder processor) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)processor, (BeanDefinitionRegistry)parserContext.getRegistry());
        RuntimeBeanReference procRef = new RuntimeBeanReference(processor.getBeanName());
        pipeline.add((Object)procRef);
        if (prevProcessor != null) {
            ManagedList successors = new ManagedList(1);
            successors.add((Object)procRef);
            prevProcessor.getPropertyValues().add(SUCCESSORS_PROPERTY, (Object)successors);
        }
        this.allProcessors.add((Object)procRef);
        prevProcessor = processor.getBeanDefinition();
        return prevProcessor;
    }
}

